/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Run {
    public static void main(String[] args) throws Exception {
        String s3;
        String interactionFile = "";
        FileReader inpFr = null;
        String path2HIPPIE = "hippie_current.txt";
        FileReader hiFr = null;
        boolean uniprot = true;
        double scoreCutoff = 0.0;
        int layer = 1;
        String outFile = null;
        FileWriter fw = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            if (s2.startsWith("-i=")) {
                s2 = s2.substring(3);
                interactionFile = s2.trim();
                try {
                    inpFr = new FileReader(interactionFile);
                }
                catch (Exception e) {
                    throw new Exception("Can't open indicated input file: " + s2);
                }
            }
            if (s2.startsWith("-h=")) {
                path2HIPPIE = s2 = s2.substring(3);
            } else if (s2.startsWith("-t=")) {
                if ((s2 = s2.substring(3)).equals("e")) {
                    uniprot = false;
                } else if (!s2.startsWith("-u=")) {
                    System.err.println("Identifier type must be either 'e' for entrez gene id or 'u' for uniprot id. Using 'u' as default.");
                }
            } else if (s2.startsWith("-s=")) {
                s2 = s2.substring(3);
                try {
                    scoreCutoff = Double.valueOf(s2);
                    if (scoreCutoff < 0.0 || scoreCutoff > 1.0) {
                        System.out.println("The score cutoff must be a value between 0 and 1. Not applying any threshold.");
                    }
                }
                catch (Exception e) {
                    System.out.println("The score cutoff must be a value between 0 and 1. Not applying any threshold.");
                }
            } else if (s2.startsWith("-l=")) {
                s2 = s2.substring(3);
                try {
                    layer = Integer.valueOf(s2);
                    if (layer < 0 || layer > 3) {
                        System.out.println("The layer number must be a value between 0 and 3. Assuming default layer size of 1.");
                    }
                }
                catch (Exception e) {
                    System.out.println("The layer number must be a value between 0 and 3. Assuming default layer size of 1.");
                }
            } else if (s2.startsWith("-o=")) {
                s2 = s2.substring(3);
                try {
                    outFile = s2;
                    fw = new FileWriter(s2);
                }
                catch (Exception e) {
                    System.err.println("Can't write to indicated outfile: " + s2);
                }
            }
            ++n2;
        }
        if (interactionFile.equals("")) {
            System.err.println("Please indicate an input file listing proteins or interactions using the '-i' flag");
            return;
        }
        try {
            hiFr = new FileReader(path2HIPPIE);
        }
        catch (Exception e) {
            System.err.println("Can't read HIPPIE at '" + path2HIPPIE + "', please indicate HIPPIE's flat file location using the '-h' flag or " + "copy HIPPIE (hippie_current.txt) to the same directory as the script");
            return;
        }
        BufferedReader br = new BufferedReader(hiFr);
        String line = br.readLine();
        if (line.split("\t").length > 6) {
            System.err.println("HIPPIE file is in wrong format. Please use the HIPPIE tab format (and not MITAB or any other format). A recent version of HIPPIE can be found at 'http://cbdm.mdc-berlin.de/tools/hippie' for download.");
        }
        line = br.readLine();
        HashMap<String, String> hippie = new HashMap<String, String>();
        while (line != null) {
            if (uniprot) {
                if (line.split("\t")[0].equals("") || line.split("\t")[2].equals("")) {
                    line = br.readLine();
                    continue;
                }
                hippie.put(String.valueOf(line.split("\t")[0]) + "%" + line.split("\t")[2], line);
            } else {
                hippie.put(String.valueOf(line.split("\t")[1]) + "%" + line.split("\t")[3], line);
            }
            line = br.readLine();
        }
        br = new BufferedReader(inpFr);
        line = br.readLine();
        HashSet<String> protStack = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        HashMap<String, String> network = new HashMap<String, String>();
        while (line != null) {
            int n3;
            int n4;
            Object object;
            if ((line = line.trim()).equals("")) {
                line = br.readLine();
                continue;
            }
            String p1 = "";
            String p2 = "";
            if (line.split(" ").length > 1) {
                object = line.split(" ");
                n4 = ((String[])object).length;
                n3 = 0;
                while (n3 < n4) {
                    s3 = object[n3];
                    if (!s3.equals("")) {
                        if (p1.equals("")) {
                            p1 = s3.trim();
                        } else {
                            p2 = s3.trim();
                        }
                    }
                    ++n3;
                }
            }
            if (p1.equals("") && line.split("\t").length > 1) {
                object = line.split("\t");
                n4 = ((String[])object).length;
                n3 = 0;
                while (n3 < n4) {
                    s3 = object[n3];
                    if (!s3.equals("")) {
                        if (p1.equals("")) {
                            p1 = s3.trim();
                        } else {
                            p2 = s3.trim();
                        }
                    }
                    ++n3;
                }
            }
            if (p1.equals("")) {
                p1 = line;
            }
            protStack.add(p1);
            if (!p2.equals("")) {
                protStack.add(p2);
                if (hippie.containsKey(String.valueOf(p1) + "%" + p2)) {
                    s3 = (String)hippie.get(String.valueOf(p1) + "%" + p2);
                    s3 = String.valueOf(s3) + "\t2";
                    network.put(String.valueOf(p1) + "%" + p2, s3);
                } else if (hippie.containsKey(String.valueOf(p2) + "%" + p1)) {
                    s3 = (String)hippie.get(String.valueOf(p2) + "%" + p1);
                    s3 = String.valueOf(s3) + "\t2";
                    network.put(String.valueOf(p2) + "%" + p1, s3);
                } else if (uniprot) {
                    s3 = String.valueOf(p1) + "\t\t" + p2 + "\t\t0\t\t1";
                    network.put(String.valueOf(p1) + "%" + p2, s3);
                } else {
                    s3 = "\t" + p1 + "\t\t" + p2 + "\t0\t\t1";
                    network.put(String.valueOf(p1) + "%" + p2, s3);
                }
            }
            line = br.readLine();
        }
        int i = 0;
        while (i != layer) {
            HashSet tmp = new HashSet();
            for (String s3 : protStack) {
                tmp.add(s3);
            }
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                s3 = (String)iterator.next();
                protStack.remove(s3);
                if (visited.contains(s3)) continue;
                visited.add(s3);
                for (String h : hippie.keySet()) {
                    String info;
                    if (!h.startsWith(String.valueOf(s3) + "%") && !h.endsWith("%" + s3)) continue;
                    String p1 = h.split("%")[0];
                    String p2 = h.split("%")[1];
                    if ((!network.containsKey(String.valueOf(p1) + "%" + p2) || network.containsKey(String.valueOf(p2) + "%" + p1)) && Double.valueOf((info = (String)hippie.get(h)).split("\t")[4]) >= scoreCutoff) {
                        network.put(String.valueOf(p1) + "%" + p2, String.valueOf(info) + "\t0");
                    }
                    if (p1.equals(s3)) {
                        protStack.add(p2);
                        continue;
                    }
                    protStack.add(p1);
                }
            }
            ++i;
        }
        if (layer == 0) {
            for (String s4 : protStack) {
                for (String t : protStack) {
                    String info;
                    if (hippie.containsKey(String.valueOf(s4) + "%" + t) && !network.containsKey(String.valueOf(s4) + "%" + t)) {
                        info = (String)hippie.get(String.valueOf(s4) + "%" + t);
                        if (!(Double.valueOf(info.split("\t")[4]) >= scoreCutoff)) continue;
                        network.put(String.valueOf(s4) + "%" + t, String.valueOf(info) + "\t0");
                        continue;
                    }
                    if (!hippie.containsKey(String.valueOf(t) + "%" + s4) || network.containsKey(String.valueOf(t) + "%" + s4) || !(Double.valueOf((info = (String)hippie.get(String.valueOf(t) + "%" + s4)).split("\t")[4]) >= scoreCutoff)) continue;
                    network.put(String.valueOf(t) + "%" + s4, String.valueOf(info) + "\t0");
                }
            }
        }
        String nl = System.getProperty("line.separator");
        for (String s5 : network.keySet()) {
            if (fw != null) {
                fw.write(String.valueOf((String)network.get(s5)) + nl);
                continue;
            }
            System.out.println((String)network.get(s5));
        }
        if (fw != null) {
            fw.close();
        }
    }
}

