/*
 * Decompiled with CFR 0.152.
 */
package rescoring;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class RunRescoring {
    public static void main(String[] args) throws Exception {
        String experimentalScoreFile = "experimental_scores.tsv";
        FileReader expFr = null;
        String path2HIPPIE = "hippie_current.txt";
        FileReader hiFr = null;
        String outFile = null;
        FileWriter fw = null;
        double as = 2.3;
        double ao = 1.6;
        double at = 0.2;
        double ws = 0.6;
        double wo = 0.1;
        double wt = 0.3;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-e=")) {
                s = s.substring(3);
                experimentalScoreFile = s.trim();
                try {
                    expFr = new FileReader(experimentalScoreFile);
                }
                catch (Exception e) {
                    throw new Exception("Can't open indicated input file: " + s);
                }
            } else if (s.startsWith("-h=")) {
                path2HIPPIE = s = s.substring(3);
            } else if (s.startsWith("-o=")) {
                s = s.substring(3);
                try {
                    outFile = s;
                    fw = new FileWriter(s);
                }
                catch (Exception e) {
                    System.err.println("Can't write to indicated outfile: " + s);
                }
            } else if (s.startsWith("-as=")) {
                as = Double.valueOf(s.substring(4));
            } else if (s.startsWith("-ao=")) {
                ao = Double.valueOf(s.substring(4));
            } else if (s.startsWith("-at=")) {
                at = Double.valueOf(s.substring(4));
            } else if (s.startsWith("-ws=")) {
                ws = Double.valueOf(s.substring(4));
            } else if (s.startsWith("-wo=")) {
                wo = Double.valueOf(s.substring(4));
            } else if (s.startsWith("-wt=")) {
                wt = Double.valueOf(s.substring(4));
            }
            ++n2;
        }
        try {
            expFr = new FileReader(experimentalScoreFile);
        }
        catch (Exception e) {
            System.err.println("Can't read file with experimental scores at '" + experimentalScoreFile + "', please indicate it's file location using the '-e' flag or " + "copy the file (experimental_scores.tsv) to the same directory as this script");
            return;
        }
        if (ws + wo + wt != 1.0) {
            System.err.println("Error: weights ws, wt and wo have to sum up to one");
        }
        System.out.println("using parameters: as=" + as + ", ao=" + ao + ", at=" + at + ", ws=" + ws + ", wo=" + wo + ", wt=" + wt);
        HashMap<String, Double> exp2score = new HashMap<String, Double>();
        BufferedReader br = new BufferedReader(expFr);
        String line = br.readLine();
        line = br.readLine();
        while (line != null) {
            exp2score.put(line.split("\t")[0], Double.valueOf(line.split("\t")[2]));
            line = br.readLine();
        }
        try {
            hiFr = new FileReader(path2HIPPIE);
        }
        catch (Exception e) {
            System.err.println("Can't read HIPPIE at '" + path2HIPPIE + "', please indicate HIPPIE's flat file location using the '-h' flag or " + "copy HIPPIE (hippie_current.txt) to the same directory as the script");
            return;
        }
        br = new BufferedReader(hiFr);
        line = br.readLine();
        if (line.split("\t").length > 6) {
            System.err.println("HIPPIE file is in wrong format. Please use the HIPPIE tab format (and not MITAB or any other format). A recent version of HIPPIE can be found at 'http://cbdm.mdc-berlin.de/tools/hippie' for download.");
        }
        String nl = System.getProperty("line.separator");
        String header = "";
        if (line.startsWith("uniprot_id_1")) {
            header = line.trim();
            if (fw != null) {
                fw.write(String.valueOf(header) + nl);
            } else {
                System.out.println(header);
            }
            line = br.readLine();
        }
        while (line != null) {
            HashSet<String> experiments = new HashSet<String>();
            String tmp = line.split("\t")[5];
            double expScore = 0.0;
            double preScore = 0.0;
            if (tmp.indexOf("experiments") > -1) {
                String tmp2 = tmp.split(";")[0].substring(12);
                StringTokenizer st = new StringTokenizer(tmp2, ",");
                while (st.hasMoreTokens()) {
                    String e = st.nextToken();
                    if (e.trim().equals("")) continue;
                    if (e.equals("two hybrid pooling approach")) {
                        e = "two hybrid fragment pooling approach";
                    } else if (e.equals("two hybrid array")) {
                        e = "Two-hybrid";
                    }
                    if (!exp2score.containsKey(e)) {
                        System.out.println("didn't find experimental type: " + e);
                        continue;
                    }
                    experiments.add(e);
                    preScore += ((Double)exp2score.get(e)).doubleValue();
                }
            }
            expScore = RunRescoring.saturatingFunction(preScore, at);
            double studyScore = 0.0;
            preScore = 0.0;
            if (tmp.indexOf("pmids") > -1) {
                StringTokenizer st = new StringTokenizer(tmp, ";");
                String tmp2 = "";
                while (st.hasMoreTokens()) {
                    tmp2 = st.nextToken();
                    if (tmp2.indexOf("pmids") > -1) break;
                }
                tmp2 = tmp2.substring(6);
                st = new StringTokenizer(tmp2, ",");
                while (st.hasMoreTokens()) {
                    String e = st.nextToken();
                    preScore += 1.0;
                }
            }
            studyScore = RunRescoring.saturatingFunction(preScore, as);
            double orthoScore = 0.0;
            preScore = 0.0;
            if (tmp.indexOf("species") > -1) {
                StringTokenizer st = new StringTokenizer(tmp, ";");
                String tmp2 = "";
                while (st.hasMoreTokens()) {
                    tmp2 = st.nextToken();
                    if (tmp2.indexOf("species") > -1) break;
                }
                tmp2 = tmp2.substring(8);
                st = new StringTokenizer(tmp2, ",");
                while (st.hasMoreTokens()) {
                    String e = st.nextToken();
                    preScore += 1.0;
                }
            }
            orthoScore = RunRescoring.saturatingFunction(preScore, ao);
            double score = ws * studyScore + wo * orthoScore + wt * expScore;
            String outString = String.valueOf(line.split("\t")[0]) + "\t" + line.split("\t")[1] + "\t" + line.split("\t")[2] + "\t" + line.split("\t")[3] + "\t" + String.format("%.2g", score) + "\t" + line.split("\t")[5];
            if (fw != null) {
                fw.write(String.valueOf(outString) + nl);
            } else {
                System.out.println(outString);
            }
            line = br.readLine();
        }
        if (fw != null) {
            fw.close();
        }
    }

    public static double saturatingFunction(double preScore, double horizontalScaling) {
        double score = 0.0;
        score = 2.0 / (1.0 + Math.exp(-horizontalScaling * preScore)) - 1.0;
        return score;
    }
}

